#version 330
#extension GL_EXT_gpu_shader4 : enable
// Ray marching practice 1Mod01.fsh by Inae

//https://www.shadertoy.com/view/XdVfDw
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define STEPS 150.
#define EPS 0.001
#define EPSN 0.01

mat2 rot(float angle){
	return mat2(cos(angle), -sin(angle), sin(angle), cos(angle));
}

float distSphere(vec3 pos, float radius){
	return length(pos) - radius;
}

float distScene(vec3 pos){
    vec3 twistedPos = vec3(rot(1.5 * sin(0.1 * pos.z + iTime)) * pos.xy, pos.z);
    vec3 repeatPos = mod(twistedPos, 1.) - 0.5;
    float dist = distSphere(repeatPos, 0.1 + 0.1 * sin(pos.z + 2. * iTime));    
    return dist;
}

vec3 getNormal(vec3 pos){
	return normalize(vec3(distScene(pos + vec3(EPSN, 0., 0.)) - distScene(pos - vec3(EPSN, 0., 0.)),
               distScene(pos + vec3(0., EPSN, 0.)) - distScene(pos - vec3(0., EPSN, 0.)),
               distScene(pos + vec3(0., 0., EPSN)) - distScene(pos - vec3(0., 0., EPSN))));
}

vec3 render(vec2 uv){
    vec3 bgcol = vec3(1. - length(uv)) + length(uv) * vec3(0., 0., 0.3);
    vec3 eye = vec3(0., 0., 3.);
    vec3 ray = normalize(vec3(uv, 0.) - eye);
    vec3 pos = eye;
    float dist, step;
    bool hit = false;
    
    for(step = 0.; step < STEPS; step++){
    	dist = distScene(pos);
        if(abs(dist) < EPS){
            hit = true;
        	break;
        }
        pos += ray * dist;
    }
    float totalDist = length(pos - eye);
    vec3 col = vec3(step / STEPS, 0.33, 0.66);
    if(hit && totalDist < 30.)col = mix(col, getNormal(pos) * 0.5 + 0.5, 0.7);
    col = mix(bgcol, col, 1./exp(totalDist * totalDist * 0.0006)); //fog
    return col;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy - 0.5 * iResolution.xy) / iResolution.x;    
    vec3 col = render(uv);
    gl_FragColor = vec4(col,1.0);
}